function RNLTV_inpainting_Fig1
% function test2_inpainting_fullWeights_synthetic1216_161029_5lo_v25_pub_s
% running time could be almost 3 hours

%setup the path
curDir=pwd; %Identify current folder

% store raw data
addessFolder = strjoin({curDir,'img_png_NLTV'},filesep);
path(addessFolder,path);

testsResFolder = 'results';
if ~exist(testsResFolder, 'dir')
    mkdir(testsResFolder);
end
testsResFolderPath = strjoin({curDir,testsResFolder},filesep);
fileName_array = {'Fig1'};

nbIter = 10000;
radius = 5;
init = 9;

application.name = 'inpainting';
application.data_term = 2;

gama = 2;
lambda  = 5000;
mu=0.3;
hsigma=0.03;

testsResSubFolderPath = strjoin({testsResFolderPath,application.name},filesep);
if ~exist(testsResSubFolderPath, 'dir')
    mkdir(testsResSubFolderPath);
end

for i_fileName = 1:length(fileName_array)
    fileName = fileName_array{i_fileName};
    
    imgResultFolderPath = strjoin({testsResSubFolderPath,...
        fileName},filesep);
    if ~exist(imgResultFolderPath, 'dir')
        mkdir(imgResultFolderPath);
    end
    
    [in_clean,map] = imread([fileName,'.png']);
    in_clean = double(in_clean)/ 255;
    
    miss_data = imread([fileName,'_miss_data.png']);
    miss_data = double(miss_data)/ 255;
    
    application.miss_data = miss_data;
    
    in_polluted = in_clean.*application.miss_data;
    
    [u,v,energies] = regularized_NLTV(in_polluted,nbIter,radius,mu,...
        lambda,gama, hsigma, init, application);
    
    psnr = psnr1(u,in_clean)
    
    imgResultNameFolderPath = strjoin({imgResultFolderPath,...
        [fileName,'_res']},filesep);
    % save image results
    save([imgResultNameFolderPath '_u_.mat'],'u');
end
